/* Wiktor Zychla, 2003 */
using System;
using System.Drawing;
using System.Windows.Forms;

namespace Example
{  
  public class CComboBox : UserControl
  {
    ComboBox cb;
    Button   bt;

    // wasne zdarzenie definiowane przez komponent
    public event EventHandler AddNewText;

    public CComboBox() 
    {
      cb      = new ComboBox(); 
      cb.Dock = DockStyle.Fill;
      
      bt      = new Button();
      bt.FlatStyle = FlatStyle.Popup;
      bt.Text = "+";
      bt.Dock = DockStyle.Right; 
      bt.Click += new EventHandler( bt_Click );

      this.Controls.AddRange( new Control[] { cb, bt } );
    }

    protected override void OnResize( EventArgs e )
    {
      bt.Size = new Size( this.Height, this.Height );           
    }    

    // przechwy klik w przycisk i na zewntrz wystaw jako AddNewText
    void bt_Click( object sender, EventArgs e )
    {
      // sprawd czy s jacy suchacze     
      if ( AddNewText != null )
        AddNewText( this, new EventArgs() );
    }
  }

  public class CMainForm : Form
  {  
    CComboBox cb1;

    public CMainForm() 
    {
      cb1      = new CComboBox();
      cb1.Size = new Size( 150, 20 );

      cb1.AddNewText += new EventHandler( cb_AddNewText );

      this.Controls.Add( cb1 );
    }

    void cb_AddNewText( object sender, EventArgs e )
    {
      MessageBox.Show( "Zgoszono zdarzenie AddNewText!" );
    }

    public static void Main()
    {    
      Application.Run( new CMainForm() );
    }
  }
}
